/*
 * Decompiled with CFR 0.152.
 */
package ags.script.commands;

import ags.script.AbstractCommand;
import ags.script.BadVariableValueException;
import ags.script.InitalizationException;
import ags.script.Target;
import ags.script.exception.FatalScriptException;

public class Call
extends AbstractCommand {
    String targetName;
    Target target;

    protected void init(String[] args) throws InitalizationException {
        if (args.length != 2) {
            throw new InitalizationException("Call expects one argument, the name of the target to call");
        }
        this.targetName = args[1];
        this.trackVariableDependencies(this.targetName);
    }

    public void checkPaths() throws BadVariableValueException {
        String translated = this.translateValue(this.targetName);
        if (this.targetName.equals(translated)) {
            this.target = Target.getTarget(this.targetName);
            if (this.target == null) {
                throw new BadVariableValueException(new Exception("Cannot find target named " + this.targetName));
            }
        }
    }

    protected void doExecute() throws FatalScriptException {
        try {
            String targetTranslatedName = this.translateValue(this.targetName);
            this.target = Target.getTarget(targetTranslatedName);
            if (this.target == null) {
                throw new BadVariableValueException(new Exception("Cannot find target named " + targetTranslatedName));
            }
            this.target.call();
        }
        catch (Exception ex) {
            throw new FatalScriptException("Error when calling target " + this.targetName, ex);
        }
    }
}

